# Arithmetic Progression

A sequence of numbers is said to be in an `Arithmetic progression` if the difference between any two consecutive terms is always the same. In simple terms, it means that the next number in the series is calculated by adding a fixed number to the previous number in the series.
For example, 2, 4, 6, 8, 10 is an AP because the difference between any two consecutive terms in the series (common difference) is same (4 - 2 = 6 - 4 = 8 - 6 = 10 - 8 = 2).
<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635132-ce38d100-d0ff-11eb-8fdf-2e14a9f640cc.png">
</p>

**Facts about Arithmetic Progression:**

1. Initial term: In an arithmetic progression, the first number in the series is called the initial term.
2. Common difference: The value by which consecutive terms increase or decrease is called the `common difference`.
3. The behavior of the arithmetic progression depends on the common difference `d`. If the common difference is positive, then the members (terms) will grow towards positive infinity. But if the common difference is negative, then the members (terms) will grow towards negative infinity.

**Formula of the nth term of an A.P:**

`a` is the initial term, and `d` is a common difference. Thus, the explicit formula is:
<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635193-25d73c80-d100-11eb-9015-344d36633704.png">
</p>

**Formula of the sum of first nth term of A.P:**

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635260-7a7ab780-d100-11eb-82a5-8ceeba3aff03.png">
</p>

**General Formulas to solve problems related to Arithmetic Progressions:**

 If `a` is the first term and `d` too, that would be a common difference:
- **nth term of an AP** = `a + (n-1)*d`.
- **Arithmetic Mean** = `Sum of all terms in the AP / Number of terms in the AP`.
- **Sum of ‘n’ terms** of an AP = 0.5 n (first term + last term) = `0.5 n [ 2a + (n-1) d ]`.

# Source

- [Arithmetic Progression](https://www.geeksforgeeks.org/arithmetic-progression)

# YouTube

- [Video URL for concept](https://youtu.be/gua96ju_FBk)
- [Video for understanding AP Dynamic Programming in C++](https://youtu.be/U_qtSRQYoPs)
